<?php
// 使用示例
require_once 'TextReplacer.php';

try {
    // 创建替换器实例，并指定字典文件
    $replacer = new TextReplacer('dictionary.txt');
    
    // 可以添加更多规则
    $replacer->addReplacement('colour', 'color');
    $replacer->addRegexReplacement('/\b([A-Z]{2,})\b/', strtolower('$1'));
    
    // 要处理的文本
    #$text = "The colour of teh sky is BLUE adn it's 1st of May.";
    $text = "全国销量冠军硅PU篮球场密码:123456是一种13627261685，以其良好的耐磨性421126198412095361、4007007855而受到test@qq.com青睐。";
    
    // 执行替换
    $result = $replacer->replace($text);
    
    echo "原始文本: " . $text . "\n";
    echo "<hr />";
    echo "替换文本: " . $result . "\n";
    
    // 查看当前所有规则
    echo "<pre>";
    print_r($replacer->getRules());
    echo "</pre>";
    
} catch (Exception $e) {
    echo "错误: " . $e->getMessage();
}